/*
  ringBuffer.c ̃eXg
  Satofumi KAMIMURA
  $Id: RingBufferTest.cpp 286 2008-10-20 09:40:22Z satofumi $
*/

#include "RingBufferTest.h"

using namespace std;

CPPUNIT_TEST_SUITE_REGISTRATION(RingBufferTest);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(RingBufferTest, "RingBufferTest");


// obt@ւ̔zuAoeXg
void RingBufferTest::fillTest(void) {

  enum { SHIFT_SIZE = 2 };
  ringBuffer_t ring;
  unsigned char ring_buffer[1 << SHIFT_SIZE];
  initRingBuffer(&ring, ring_buffer, SHIFT_SIZE);
  
  CPPUNIT_ASSERT_EQUAL(3, getRingFreeSize(&ring));
  CPPUNIT_ASSERT_EQUAL(0, getRingFillSize(&ring));
  unsigned char expected[] = "abc";
  
  putRingBufferStr(&ring, expected, 3);
  CPPUNIT_ASSERT_EQUAL(0, getRingFreeSize(&ring));
  CPPUNIT_ASSERT_EQUAL(3, getRingFillSize(&ring));

  unsigned char buffer[3] = { 0, 0, 0 };
  getRingBufferStr(&ring, buffer, 3);
  CPPUNIT_ASSERT_EQUAL(3, getRingFreeSize(&ring));
  CPPUNIT_ASSERT_EQUAL(0, getRingFillSize(&ring));

  CPPUNIT_ASSERT_EQUAL(string((char *)expected), string((char *)buffer, 3));
}


// Oobt@[e[g邩eXg
void RingBufferTest::rotateTest(void) {

  enum { SHIFT_SIZE = 2 };
  ringBuffer_t ring;
  unsigned char ring_buffer[1 << SHIFT_SIZE];
  initRingBuffer(&ring, ring_buffer, SHIFT_SIZE);
  
  CPPUNIT_ASSERT_EQUAL(3, getRingFreeSize(&ring));
  CPPUNIT_ASSERT_EQUAL(0, getRingFillSize(&ring));

  putRingBuffer(&ring, 'd');
  CPPUNIT_ASSERT_EQUAL(2, getRingFreeSize(&ring));
  CPPUNIT_ASSERT_EQUAL(1, getRingFillSize(&ring));

  putRingBuffer(&ring, 'e');
  CPPUNIT_ASSERT_EQUAL(1, getRingFreeSize(&ring));
  CPPUNIT_ASSERT_EQUAL(2, getRingFillSize(&ring));

  unsigned char buffer[3] = { 0, 0, 0 };
  getRingBufferStr(&ring, buffer, 2);
  CPPUNIT_ASSERT_EQUAL(3, getRingFreeSize(&ring));
  CPPUNIT_ASSERT_EQUAL(0, getRingFillSize(&ring));
  CPPUNIT_ASSERT_EQUAL(string("de"), string((char *)buffer, 2));

  putRingBufferStr(&ring, (unsigned char *)"fg", 2);
  CPPUNIT_ASSERT_EQUAL(1, getRingFreeSize(&ring));
  CPPUNIT_ASSERT_EQUAL(2, getRingFillSize(&ring));

  getRingBufferStr(&ring, buffer, 2);
  CPPUNIT_ASSERT_EQUAL(3, getRingFreeSize(&ring));
  CPPUNIT_ASSERT_EQUAL(0, getRingFillSize(&ring));
  CPPUNIT_ASSERT_EQUAL(string("fg"), string((char *)buffer, 2));
}
