#ifndef ENC_CTRL_H
#define ENC_CTRL_H

/*!
  \file
  \brief GR[_

  GR[_foCX̊Ǘs(SH7045Fˑ)

  \author Satofumi KAMIMURA

  $Id: encCtrl.h 286 2008-10-20 09:40:22Z satofumi $
*/

#include "robotParams.h"


/*!
  \brief GR[_lƂ̃[^̉]ݒ

  bA[^ CW ɉ]ƂɃGR[_lꍇɂ ENC_CCW_PLUSE pB
*/
enum EncDirSetting {
  ENC_CCW_TO_PLUSE = -1, /*!< CCW Ƀ[^]ƃGR[_l */
  ENC_CW_TO_PLUSE = +1,	/*!< CW Ƀ[^]ƃGR[_l*/
};


#ifndef ENC_PULSE
#define ENC_PULSE 512 * 4	/*!< GR[_̕\ */
#endif


/*!
 \brief GR[_p̍\

 GR[_ɕKvȃp[^AԂǗ
*/
typedef struct {
  short diff;		/*!< OĂяõGR[_l̕ψʗ */
  unsigned short prev;		/*!< OĂяõGR[_l */
  unsigned char id;		/*!< gpGR[_̃foCXID */
  char enc_direction;	/*!< [^ƃGR[_̎t̏ */
  int total;			/*!< GR[_l̑ړ */
} encInfo_t;


extern void initEnc(void);
extern void initEncInfo(const unsigned char id, encInfo_t *enc);
extern void updateEncDiff(encInfo_t *enc);
extern int getEncDiff(encInfo_t *enc);

#endif /* !ENC_CTRL_H */
