/*
  linker script for SH7045F(alpha project)
  Satofumi KAMIMURA
  $Id: sh45load.x,v 1.1 2004/06/09 01:07:20 satofumi Exp $
*/

OUTPUT_FORMAT("coff-sh")
OUTPUT_ARCH(sh)
MEMORY
{
  rom(wx)   : o = 0x00000000, l = 256K
  ram(rw)   : o = 0x00400000, l = 1M
  stack(rw) : o = 0xfffff000, l = 4K
}
SECTIONS
{
  .text :
  {
    *(.text)
    *(.strings)
     _vec_ram = . ;
   LONG(ABSOLUTE(start0))	/* 0 */
   LONG(ABSOLUTE(_stack))	/* 1 */
   LONG(ABSOLUTE(start0))	/* 2 */
   LONG(ABSOLUTE(_stack))	/* 3 */
   LONG(DEFINED(_futou1)?ABSOLUTE(_futou1):ABSOLUTE(0x0008))	/* 4 */
   . += 4;							/* 5 */
   LONG(DEFINED(_futou2)?ABSOLUTE(_futou2):ABSOLUTE(0x0008))	/* 6 */
   . += 4*2;							/* 7,8 */
   LONG(DEFINED(_adderr1)?ABSOLUTE(_adderr1):ABSOLUTE(0x0008))	/* 9 */
   LONG(DEFINED(_adderr2)?ABSOLUTE(_adderr2):ABSOLUTE(0x0008))	/* 10 */
   LONG(DEFINED(_nmi)?ABSOLUTE(_num):ABSOLUTE(0x0008))		/* 11 */
   LONG(DEFINED(_usr)?ABSOLUTE(_usr):ABSOLUTE(0x0008))		/* 12 */
   . += 4*51;							/* 13-63 */
   LONG(DEFINED(_irq0)?ABSOLUTE(_irq0):ABSOLUTE(0x0008))	/* 64 */
   LONG(DEFINED(_irq1)?ABSOLUTE(_irq1):ABSOLUTE(0x0008))	/* 65 */
   LONG(DEFINED(_irq2)?ABSOLUTE(_irq2):ABSOLUTE(0x0008))	/* 66 */
   LONG(DEFINED(_irq3)?ABSOLUTE(_irq3):ABSOLUTE(0x0008))	/* 67 */
   LONG(DEFINED(_irq4)?ABSOLUTE(_irq4):ABSOLUTE(0x0008))	/* 68 */
   LONG(DEFINED(_irq5)?ABSOLUTE(_irq5):ABSOLUTE(0x0008))	/* 69 */
   LONG(DEFINED(_irq6)?ABSOLUTE(_irq6):ABSOLUTE(0x0008))	/* 70 */
   LONG(DEFINED(_irq7)?ABSOLUTE(_irq7):ABSOLUTE(0x0008))	/* 71 */
   LONG(DEFINED(_dmac0)?ABSOLUTE(_dmac0):ABSOLUTE(0x0008))	/* 72 */
   . += 4*3;							/* 73-75 */
   LONG(DEFINED(_dmac1)?ABSOLUTE(_dmac1):ABSOLUTE(0x0008))	/* 76 */
   . += 4*3;							/* 77-79 */
   LONG(DEFINED(_dmac2)?ABSOLUTE(_dmac2):ABSOLUTE(0x0008))	/* 80 */
   . += 4*3;							/* 81-83 */
   LONG(DEFINED(_dmac3)?ABSOLUTE(_dmac3):ABSOLUTE(0x0008))	/* 84 */
   . += 4*3;							/* 85-87 */
   LONG(DEFINED(_tgi0a)?ABSOLUTE(_tgi0a):ABSOLUTE(0x0008))	/* 88 */
   LONG(DEFINED(_tgi0b)?ABSOLUTE(_tgi0b):ABSOLUTE(0x0008))	/* 89 */
   LONG(DEFINED(_tgi0c)?ABSOLUTE(_tgi0c):ABSOLUTE(0x0008))	/* 90 */
   LONG(DEFINED(_tgi0d)?ABSOLUTE(_tgi0d):ABSOLUTE(0x0008))	/* 91 */
   LONG(DEFINED(_tgi0v)?ABSOLUTE(_tgi0v):ABSOLUTE(0x0008))	/* 92 */
   . += 4*3;							/* 93-95 */
   LONG(DEFINED(_tgi1a)?ABSOLUTE(_tgi1a):ABSOLUTE(0x0008))	/* 96 */
   LONG(DEFINED(_tgi1b)?ABSOLUTE(_tgi1b):ABSOLUTE(0x0008))	/* 97 */
   . += 4*2;							/* 98,99 */
   LONG(DEFINED(_tgi1c)?ABSOLUTE(_tgi1v):ABSOLUTE(0x0008))	/* 100 */
   LONG(DEFINED(_tgi1d)?ABSOLUTE(_tgi1u):ABSOLUTE(0x0008))	/* 101 */
   . += 4*2;							/* 102,103 */
   LONG(DEFINED(_tgi2a)?ABSOLUTE(_tgi2a):ABSOLUTE(0x0008))	/* 104 */
   LONG(DEFINED(_tgi2b)?ABSOLUTE(_tgi2b):ABSOLUTE(0x0008))	/* 105 */
   . += 4*2;							/* 106,107 */
   LONG(DEFINED(_tgi2c)?ABSOLUTE(_tgi2v):ABSOLUTE(0x0008))	/* 108 */
   LONG(DEFINED(_tgi2d)?ABSOLUTE(_tgi2u):ABSOLUTE(0x0008))	/* 109 */
   . += 4*2;							/* 110,111*/
   LONG(DEFINED(_tgi3a)?ABSOLUTE(_tgi3a):ABSOLUTE(0x0008))	/* 112 */
   LONG(DEFINED(_tgi3b)?ABSOLUTE(_tgi3b):ABSOLUTE(0x0008))	/* 113 */
   LONG(DEFINED(_tgi3c)?ABSOLUTE(_tgi3c):ABSOLUTE(0x0008))	/* 114 */
   LONG(DEFINED(_tgi3d)?ABSOLUTE(_tgi3d):ABSOLUTE(0x0008))	/* 115 */
   LONG(DEFINED(_tgi3v)?ABSOLUTE(_tgi3v):ABSOLUTE(0x0008))	/* 116 */
   . += 4*3;							/* 117-119 */
   LONG(DEFINED(_tgi4a)?ABSOLUTE(_tgi4a):ABSOLUTE(0x0008))	/* 120 */
   LONG(DEFINED(_tgi4b)?ABSOLUTE(_tgi4b):ABSOLUTE(0x0008))	/* 121 */
   LONG(DEFINED(_tgi4c)?ABSOLUTE(_tgi4c):ABSOLUTE(0x0008))	/* 122 */
   LONG(DEFINED(_tgi4d)?ABSOLUTE(_tgi4d):ABSOLUTE(0x0008))	/* 123 */
   LONG(DEFINED(_tgi4v)?ABSOLUTE(_tgi4v):ABSOLUTE(0x0008))	/* 124 */
   . += 4*3;							/* 125-127 */
   LONG(DEFINED(_eri0)?ABSOLUTE(_eri0):ABSOLUTE(0x0008))	/* 128 */
   LONG(DEFINED(_rxi0)?ABSOLUTE(_rxi0):ABSOLUTE(0x0008))	/* 129 */
   LONG(DEFINED(_txi0)?ABSOLUTE(_txi0):ABSOLUTE(0x0008))	/* 130 */
   LONG(DEFINED(_tei0)?ABSOLUTE(_tei0):ABSOLUTE(0x0008))	/* 131 */
   LONG(DEFINED(_eri1)?ABSOLUTE(_eri1):ABSOLUTE(0x0008))	/* 132 */
   LONG(DEFINED(_rxi1)?ABSOLUTE(_rxi1):ABSOLUTE(0x0008))	/* 133 */
   LONG(DEFINED(_txi1)?ABSOLUTE(_txi1):ABSOLUTE(0x0008))	/* 134 */
   LONG(DEFINED(_tei1)?ABSOLUTE(_tei1):ABSOLUTE(0x0008))	/* 135 */
   LONG(DEFINED(_adi)?ABSOLUTE(_adi):ABSOLUTE(0x0008))		/* 136 */
   . += 4*3;							/* 137-139 */
   LONG(DEFINED(_swdtce)?ABSOLUTE(_swdtce):ABSOLUTE(0x0008))	/* 140 */
   . += 4*3;							/* 141-143 */
   LONG(DEFINED(_cmi0)?ABSOLUTE(_cmi0):ABSOLUTE(0x0008))	/* 144 */
   . += 4*3;							/* 145-147 */
   LONG(DEFINED(_cmi1)?ABSOLUTE(_cmi1):ABSOLUTE(0x0008))	/* 148 */
   . += 4*3;							/* 149-151 */
   LONG(DEFINED(_iti)?ABSOLUTE(_iti):ABSOLUTE(0x0008))		/* 152 */
   LONG(DEFINED(_cmi)?ABSOLUTE(_cmi):ABSOLUTE(0x0008))		/* 153 */
   . += 4*2;							/* 154,155 */
   LONG(DEFINED(_oei)?ABSOLUTE(_oei):ABSOLUTE(0x0008))		/* 156 */

     _etext = . ;
  }  > ram
  .tors :
  {
    _cp_start = . ;
    ___ctors = . ;
    *(.ctors)
    ___ctors_end = . ;
    ___dtors = . ;
    *(.dtors)
    ___dtors_end = . ;
  } > ram
  .data :
  {
    *(.data)
     _edata = . ;
     _cp_end = . ;
  }  > ram
  .bss :
  {
     _bss_start = . ;
    *(.bss)
    *(COMMON)
     _end = . ;
  }  > ram

  .stack  0x00400000+1M-0x10 (NOLOAD) :
  {
     _stack = . ;
    *(.stack)
  }  > ram

  .stab 0 (NOLOAD) :
  {
    *(.stab)
  }
  .stabstr 0 (NOLOAD) :
  {
    *(.stabstr)
  }
}
