#ifndef COORDINATE_CTRL_TEST_H
#define COORDINATE_CTRL_TEST_H

/*!
  \file
  \brief coordinateCtrl.cpp ̃eXg
  
  \author Satofumi KAMIMURA
  
  $Id: CoordinateCtrlTest.h 286 2008-10-20 09:40:22Z satofumi $
*/

#include <cppunit/extensions/HelperMacros.h>
#include "coordinateCtrl.h"


class CoordinateCtrlTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(CoordinateCtrlTest);
  CPPUNIT_TEST(compileTest);
  CPPUNIT_TEST(setParentCoordinate);
  CPPUNIT_TEST(adjustPositionTest);
  CPPUNIT_TEST(getOtherCrdPositionTest);
  CPPUNIT_TEST(getCrdPositionTest);
  CPPUNIT_TEST(nortifyTest);
  CPPUNIT_TEST_EXCEPTION(setOwnCrdToCrdLoopExTest, CrdCtrl_Exception);
  CPPUNIT_TEST_EXCEPTION(adjustCrdExTest, CrdCtrl_Exception);
  CPPUNIT_TEST_SUITE_END();

public:
  void compileTest(void);
  void setParentCoordinate(void);
  void adjustPositionTest(void);
  void getOtherCrdPositionTest(void);
  void getCrdPositionTest(void);
  void nortifyTest(void);
  void setOwnCrdToCrdLoopExTest(void);
  void adjustCrdExTest(void);
};

#endif /* !COORDINATE_CTRL_TEST_H */
