#ifndef PACKET_HANDLER_HOST_H
#define PACKET_HANDLER_HOST_H

/*!
  \file
  \brief pPbg

  \author Satofumi KAMIMURA

  $Id: packetHandleHost.h 286 2008-10-20 09:40:22Z satofumi $
*/

#ifdef __cplusplus
#include "connectionDevice.h"
#else
#define ConnectionDevice int
#endif
#include "structTables.h"
#include "nodeAccess.h"


#define WRITE_PACKET_INIT \
  packetInfo_t pa; \
  ++unique_id; \
  initPacketInfo(&pa, (unsigned char *)send_packet, \
		 (unsigned char *)tbl, PACKET_WRITE_REQUEST, \
		 getStructId(node, (unsigned char *)tbl), unique_id);

#define READ_PACKET_INIT \
  char send_packet[SEND_PACKET_SIZE]; \
  int send_size = 0; \
  packetInfo_t pa; \
  ++unique_id; \
  initPacketInfo(&pa, (unsigned char *)send_packet, \
		 (unsigned char *)tbl, PACKET_READ_REQUEST, \
		 getStructId(node, (unsigned char *)tbl), unique_id);

extern int waitPacketResponse(ConnectionDevice* con, runCtrl_t* tbl,
			      char* send_packet, int send_size, int unique_id);
extern void set_runRetryTimes(int times);
extern void set_runRecvTimeout(int timeout);

#endif /* !PACKET_HANDLER_HOST_H */
