/*
  PWM o͂svO
  Satofumi KAMIMURA
  $Id: pwmCtrl.cpp 286 2008-10-20 09:40:22Z satofumi $
*/

#if !MONITOR
#include <runCtrl.h>
#else
#include <mRunCtrl.h>
#endif
#include <vutils.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

using namespace VXV;


int main(int argc, char *argv[]) {
  try {
#if !MONITOR
    RunCtrl run;
#else
    mRunCtrl run;
    vmonitor::show();
#endif
    if (run.connect(argc, argv) < 0) {
      printf("RunCtrl::connect: %s\n", run.what());
      exit(1);
    }

    for (int i = 0; i < 2; ++i) {
      run.setMotorMode(i, CW);
    }

    // q, Q ͂ꂽ~ďI
    unsigned char duty = 0;
    int inputed = 0;

    while (1) {
      scanf("%d", &inputed);
      if ((inputed >= 0) && (inputed <= 255)) {
	duty = inputed;
	unsigned char duty_array[2] = { duty, duty };
	for (int i = 0; i < 2; ++i) {
	  run.setMotorPwm(i, duty_array, 2);
	}

      } else if (inputed < 0) {
	break;
      }
    }
    run.stop();

  } catch (std::exception& e) {
    printf("exception: %s\n", e.what());
  }
  return 0;
}
