/*
  ~ʒǏ]̃Tv
  Satofumi KAMIMURA
  $Id: followCircle.cpp 286 2008-10-20 09:40:22Z satofumi $
*/

#if !MONITOR
#include <runCtrl.h>
#else
#include <mRunCtrl.h>
#endif
#include <pathUtils.h>
#include <stdio.h>
#include <stdlib.h>

using namespace VXV;


int main(int argc, char *argv[]) {
  try {
#if !MONITOR
    RunCtrl run;
#else
    mRunCtrl run;
    vmonitor::show();
#endif
    if (run.connect(argc, argv) < 0) {
      printf("RunCtrl::connect: %s\n", run.what());
      exit(1);
    }

    run.followCircleOnTangent(Position(500, 0, deg(0)), -250);
    Position pos;
    do {
      VXV::Delay(100);
    } while (abs(run.getAngleToDirection(deg(-90)).to_deg()) > 10);

    run.followLine(Position(800, 0, deg(0)));
    while (run.getLengthToLine(Position(800, 0, deg(0))) < 0) {
      VXV::Delay(100);
    }
    run.followCircle(Grid(1000, 0), +250);
    VXV::Delay(10000);

    run.stop();
    VXV::Delay(1000);

  } catch (std::exception& e) {
    printf("exception: %s\n", e.what());
  }
  return 0;
}
