/*
  WnR}h̗p
  Satofumi KAMIMURA
  $Id: coordinate.cpp 286 2008-10-20 09:40:22Z satofumi $
*/

#if !MONITOR
#include <runCtrl.h>
#else
#include <mRunCtrl.h>
#endif
#include <typePrint.h>
#include <stdio.h>
#include <stdlib.h>

using namespace VXV;


// ʒȕo
static void printCrdPosition(RunCtrl& run) {
  Position crdPos = run.getCrdPosition();
  Position runPos = run.getRunPosition();
  Position localPos = run.getLocalPosition();
  std::cout << "Crd: " << crdPos << ",\t"
	    << "Local: " << localPos << ",\t"
	    << "Run: " << runPos << std::endl;
}


int main(int argc, char *argv[]) {
  try {
#if !MONITOR
    RunCtrl run;
#else
    mRunCtrl run;
#endif
    if (run.connect(argc, argv) < 0) {
      printf("RunCtrl::connect: %s\n", run.what());
      exit(1);
    }
#if MONITOR
    vmonitor::show();
#endif

    // Ԃ̏
    printCrdPosition(run);

    // Wň_ړ
    run.adjustCrdPosition(Position(100, 0, deg(0)));
    printCrdPosition(run);
#if MONITOR
    VXV::Delay(1000);
#endif

    // {bgʒuC
    run.adjustRunPosition(Position(200, 0, deg(0)));
    printCrdPosition(run);
#if MONITOR
    VXV::Delay(1000);
#endif

    // ܂A
    // adjustCrdPosition: Wň_ʒuύXA{bgʒuXV
    // adjustRunPosition: Wñ{bgʒuύXA{bgʒuXV

  } catch (std::exception& e) {
    printf("exception: %s\n", e.what());
  }
  return 0;
}
