#ifndef RUN_CTRL_H
#define RUN_CTRL_H

/*!
  \file
  \brief 走行制御インターフェース

  \author Satofumi KAMIMURA

  $Id: RunCtrl.h 283 2008-10-19 21:31:36Z satofumi $
*/

#include "Coordinate.h"
#include "AdditionalRunCommands.h"


namespace qrk
{
  class Connection;

  class RunCtrl
  {
  public:
    virtual ~RunCtrl(void) {}
    virtual const char* what(void) const = 0;

    virtual void pushState(void) = 0;
    virtual void popState(void) = 0;

    virtual bool connect(const char* device, long baudrate) = 0;
    virtual bool connect(Connection* con) = 0;
    virtual void disconnect(void) = 0;

    virtual void followLine(const Position<int>& position) = 0;
    virtual void followCircle(const Grid<int>& point, const int radius) = 0;

    virtual void stopToLine(const Grid<int>& point, const Angle& angle) = 0;
    virtual void stopToDirection(const Angle& angle) = 0;

    virtual void rotateAngle(const Angle& angle) = 0;
    virtual void rotate(const Angle& angle_sec) = 0;

    virtual void stop(void) = 0;

    virtual Position<int> position(Coordinate* coordinate, int* timestamp) = 0;
    virtual bool isStable(void) = 0;

    virtual void setStraightVelocity(int mm_sec) = 0;
    virtual int straightVelocity(void) = 0;

    virtual void setStraightAcceleration(int mm_sec2) = 0;

    virtual void setRotateVelocity(const Angle& angle_sec) = 0;
    virtual Angle rotateVelocity(void) = 0;
    virtual void setRotateAcceleration(const Angle& angle_sec2) = 0;
  };
};

#endif /* !RUN_CTRL_H */
