#ifndef DIFFERENTIAL_DRIVE_H
#define DIFFERENTIAL_DRIVE_H

/*!
  \file
  \brief 走行制御

  \author Satofumi KAMIMURA

  $Id: DifferentialDrive.h 283 2008-10-19 21:31:36Z satofumi $
*/

#include "RunCtrl.h"
#include "Coordinate.h"
#include "AdditionalRunCommands.h"


namespace qrk
{
  class Connection;

  class DifferentialDrive : public RunCtrl,
                            public Coordinate,
                            public AdditionalRunCommands
  {
    DifferentialDrive(const DifferentialDrive& rhs);
    DifferentialDrive& operator = (const DifferentialDrive& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;


  private:
    Position<int> position(Coordinate* coordinate = NULL);

  public:
    enum {
      DefaultBaudrate = 115200,
    };

    DifferentialDrive(void);
    ~DifferentialDrive(void);

    const char* what(void) const;

    void pushState(void);
    void popState(void);

    bool connect(const char* device, long baudrate = DefaultBaudrate);
    bool connect(Connection* con);
    void setConnection(Connection* con);
    Connection* connection(void);
    void disconnect(void);
    bool isConnected(void);

    void setServo(bool on);

    void followLine(const Position<int>& position);
    void followCircle(const Grid<int>& point, const int radius);

    void stopToLine(const Grid<int>& point, const Angle& angle);
    void stopToDirection(const Angle& angle);

    void rotateAngle(const Angle& angle);
    void rotate(const Angle& angle_sec);

    void stop(void);

    Position<int> position(Coordinate* coordinate, int* timestamp);
    bool isStable(void);

    void setStraightVelocity(int mm_sec);
    int straightVelocity(void);

    void setStraightAcceleration(int mm_sec2);

    void setRotateVelocity(const Angle& angle_sec);
    Angle rotateVelocity(void);
    void setRotateAcceleration(const Angle& angle_sec2);
  };
};

#endif /* !DIFFERENTIAL_DRIVE_H */
