/*!
  \file
  \brief 走行制御

  \author Satofumi KAMIMURA

  $Id: DifferentialDrive.cpp 283 2008-10-19 21:31:36Z satofumi $
*/

#include "DifferentialDrive.h"
#include "runCtrl/cpp/runCtrl.h"

using namespace qrk;


struct DifferentialDrive::pImpl
{
  VXV::RunCtrl run;
};


DifferentialDrive::DifferentialDrive(void) : pimpl(new pImpl)
{
}


DifferentialDrive::~DifferentialDrive(void)
{
}


const char* DifferentialDrive::what(void) const
{
  return pimpl->run.what();
}


void DifferentialDrive::pushState(void)
{
  pimpl->run.push_runState();
}


void DifferentialDrive::popState(void)
{
  pimpl->run.pop_runState();
}


bool DifferentialDrive::connect(const char* device, long baudrate)
{
  return (pimpl->run.connect(device, baudrate) < 0) ? false : true;
}


//!< \attention 
bool DifferentialDrive::connect(Connection* con)
{
  // !!!
  return false;
}


void DifferentialDrive::setConnection(Connection* con)
{
  // !!!
}


Connection* DifferentialDrive::connection(void)
{
  // !!!
  return NULL;
}


void DifferentialDrive::disconnect(void)
{
  pimpl->run.disconnect();
}


bool DifferentialDrive::isConnected(void)
{
  return pimpl->run.isConnected();
}


void DifferentialDrive::setServo(bool on)
{
  pimpl->run.servoCtrl(on);
}


void DifferentialDrive::followLine(const Position<int>& position)
{
  VXV::Position pos(position.x, position.y, VXV::rad(position.to_rad()));
  pimpl->run.followLine(pos, VXV::GL);
}


void DifferentialDrive::followCircle(const Grid<int>& point, const int radius)
{
  VXV::Grid pos(point.x, point.y);
  pimpl->run.followCircle(pos, radius, VXV::GL);
}


void DifferentialDrive::stopToLine(const Grid<int>& point, const Angle& angle)
{
  VXV::Position pos(point.x, point.y, VXV::rad(angle.to_rad()));
  pimpl->run.stopToLine(pos, VXV::GL);
}


void DifferentialDrive::stopToDirection(const Angle& angle)
{
  pimpl->run.rotateToDirection(VXV::rad(angle.to_rad()), VXV::GL);
}


void DifferentialDrive::rotateAngle(const Angle& angle)
{
  pimpl->run.rotateAngle(VXV::rad(angle.to_rad()));
}


void DifferentialDrive::rotate(const Angle& angle_sec)
{
  pimpl->run.spin(VXV::rad(angle_sec.to_rad()));
}


void DifferentialDrive::stop(void)
{
  pimpl->run.stop();
}


Position<int> DifferentialDrive::position(Coordinate* coordinate,
                                          int* timestamp)
{
  VXV::Position pos = pimpl->run.getRunPosition();
  if (timestamp) {
    *timestamp = pimpl->run.crd_ticks;
  }
  Position<int> position = Position<int>(pos.x, pos.y, rad(pos.zt.to_rad()));
  return pointPosition(coordinate, position);
}


Position<int> DifferentialDrive::position(Coordinate* coordinate)
{
  return position(coordinate);
}


bool DifferentialDrive::isStable(void)
{
  return pimpl->run.isStable();
}


void DifferentialDrive::setStraightVelocity(int mm_sec)
{
  pimpl->run.setStraightRefVel(mm_sec);
}


int DifferentialDrive::straightVelocity(void)
{
  return pimpl->run.getStraightVel();
}


void DifferentialDrive::setStraightAcceleration(int mm_sec2)
{
  pimpl->run.setStraightRefAcc(mm_sec2);
}


void DifferentialDrive::setRotateVelocity(const Angle& angle_sec)
{
  pimpl->run.setRotateRefVel(VXV::rad(angle_sec.to_rad()));
}


Angle DifferentialDrive::rotateVelocity(void)
{
  VXV::Direction velocity = pimpl->run.getRotateVel();
  return rad(velocity.to_rad());
}


void DifferentialDrive::setRotateAcceleration(const Angle& angle_sec2)
{
  pimpl->run.setRotateRefAcc(VXV::rad(angle_sec2.to_rad()));
}
