/*!
  \file
  \brief UrgUsbComCom の動作サンプル

  \author Satofumi KAMIMURA

  $Id: searchUrgPort.cpp 179 2008-08-28 00:10:05Z satofumi $
*/

#include "UrgUsbCom.h"
#include "FindComPorts.h"

using namespace qrk;


//! main
int main(int argc, char *argv[]) {

  // COM 一覧の取得
  UrgUsbCom urg_usb;
  FindComPorts find_com_ports(&urg_usb);
  std::vector<std::string> com_ports = find_com_ports.find();

  // 取得した COM 一覧を表示
  for (std::vector<std::string>::iterator it = com_ports.begin();
       it != com_ports.end(); ++it) {
    // URG ポートの場合は、"[URG]" と追記する
    const char* com_name = it->c_str();
    printf("%s %s\n", com_name, (urg_usb.isUsbCom(com_name) ? "[URG]" : ""));
  }

  return 0;
}
