/*!
  \file
  \brief recvCaptureData() が QT を処理できるかの動作サンプル

  \author Satofumi KAMIMURA

  $Id: recvQtSample.cpp 187 2008-08-30 10:26:11Z satofumi $
*/

#include <SDL.h>
#include "ScipHandler.h"
#include "SerialCtrl.h"
#include "ConnectWithScip.h"
#include "delay.h"

using namespace qrk;


//! main
int main(int argc, char *argv[]) {

  SerialCtrl con;
  const char* error_message = connectWithScip(con);
  if (error_message) {
    printf("%s\n", error_message);
    exit(1);
  }

  ScipHandler scip;
  scip.setConnection(&con);

  // MD での連続取得
  con.send("MD0000000101000\r", 16);

  // QT の送信
  delay(300);
  con.send("QT\r", 3);

  ScipHandler::RawRecvData raw_data;
  for (size_t i = 0; i < 100; ++i) {
    bool ret = scip.recvCaptureData(raw_data);
    printf("%d: %s\n", i, ret ? "true" : "false");
    if (raw_data.type == ScipHandler::QT) {
      printf("QT found !\n");
      break;
    }
  }
  printf("End.\n");

  // 一応、消灯指示
  scip.setLaserOutput(ScipHandler::Off, ScipHandler::Force);

  return 0;
}
