/*!
  \file
  \brief ME コマンドの受信サンプル

  Top-URG 専用

  \author Satofumi KAMIMURA

  $Id: recvMeSample.cpp 187 2008-08-30 10:26:11Z satofumi $
*/

#include "UrgCtrl.h"
#include "ScipHandler.h"
#include "SensorParameter.h"
#include "Connection.h"
#include "delay.h"

using namespace qrk;


static bool splitMeData(std::vector<long>& length_data,
                        std::vector<long>& intensity_data,
                        const std::vector<long>& dual_data) {

  if (dual_data.empty() || (dual_data.size() % 2)) {
    return false;
  }

  // データを length と intensity とに分割する
  for (std::vector<long>::const_iterator it = dual_data.begin();
       it != dual_data.end();) {

    length_data.push_back(*it);
    ++it;

    intensity_data.push_back(*it);
    ++it;
  }
  return true;
}


//! main
int main(int argc, char *argv[]) {

  // const char device[] = "COM3";
  const char device[] = "/dev/ttyACM0";

  // URG に接続
  UrgCtrl urg;
  if (! urg.connect(device)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }
  urg.setCaptureMode(ManualCapture);

  // パラメータの取得
  SensorParameter parameter;
  urg.sensorParameter(&parameter);
  size_t scan_msec = urg.scanMsec();

  // 発光させる
  urg.setLaserOutput(UrgCtrl::On);

  // ME データ受信
  int first = 0;
  int last = parameter.area_max;
  char me_command[] = "MEsssseeeeggstt\r";
  size_t me_size = strlen(me_command);

  enum { CaptureTimes = 3 };
  snprintf(me_command, me_size + 1,
           "ME%04d%04d%02d%01d%02d\r", first, last, 1, 0, CaptureTimes);

  ScipHandler* scip = urg.scipHandler();
  Connection* con = scip->connection();

  con->send(me_command, me_size);

  // 最初のエコーバック分を無視するために、繰り返し回数に +1 してある
  for (size_t i = 0; i < (CaptureTimes + 1); ++i) {

    delay(scan_msec);

    ScipHandler::RawRecvData raw_data;
    scip->recvCaptureData(raw_data);

#if 0
    size_t n = raw_data.lines.size();
    fprintf(stderr, "lines: %d\n", n);
    for (size_t j = 0; j < n; ++j) {
      fprintf(stderr, "%s\n", raw_data.lines[j].c_str());
    }
#endif

    // 取得データを距離と強度に分割する
    std::vector<long> dual_data;
    scip->convertToLength(dual_data, raw_data);
    raw_data.lines.clear();

    std::vector<long> length_data;
    std::vector<long> intensity_data;
    if (! splitMeData(length_data, intensity_data, dual_data)) {
      continue;
    }

    long front_length = length_data[parameter.area_front];
    long front_intensity = intensity_data[parameter.area_front];
    fprintf(stderr, "front: length:%ld, intensity:%ld\n",
            front_length, front_intensity);
  }

  return 0;
}
