/*!
  \file
  \brief SCIP 1.1 での距離データ取得

  \author Satofumi KAMIMURA

  $Id: recvClassicGSample.cpp 136 2008-07-29 10:27:20Z satofumi $
*/

#include <SDL.h>
#include "SerialCtrl.h"
#include "ScipHandler.h"
#include "ConnectWithScip.h"

using namespace qrk;


//! main
int main(int argc, char *argv[]) {

  SerialCtrl con;
  const char* error_message = connectWithScip(con, SCIP_11);
  if (error_message) {
    printf("%s\n", error_message);
    exit(1);
  }

  ScipHandler scip;
  scip.setConnection(&con);

  con.send("G00076801\r", 10);

  ScipHandler::RawRecvData raw_data;
  if (! scip.recvCaptureData(raw_data)) {
    printf("ScipHandler::recvCaptureData(): %s\n", scip.what());
    exit(1);
  }

  std::vector<long> length;
  scip.convertToLength(length, raw_data, ScipHandler::SCIP_11);

  printf("error_code: %d\n", raw_data.error_code);
  printf("timestamp: %ld\n", raw_data.timestamp);
  printf("capture_first: %d\n", raw_data.capture_first);
  printf("capture_last: %d\n", raw_data.capture_last);
  printf("skip_lines: %d\n", raw_data.skip_lines);
  printf("skip_frames: %d\n", raw_data.skip_frames);
  printf("left_times: %d\n", raw_data.left_times);

  if (length.size() != (768 + 1)) {
    printf("length data size: %d\n", length.size());
    exit(1);
  }

  printf("n = %d\n", length.size());
  for (std::vector<long>::iterator it = length.begin();
       it != length.end(); ++it) {
    printf("%ld, ", *it);
  }
  printf("\n");

  return 0;
}
