/*!
  \file
  \brief recvCaptureData の動作サンプル

  \author Satofumi KAMIMURA

  $Id: recvCaptureDataSample.cpp 136 2008-07-29 10:27:20Z satofumi $
*/

#include <SDL.h>
#include "ScipHandler.h"
#include "SerialCtrl.h"
#include "ConnectWithScip.h"

//#include "ConnectionUtils.h"

using namespace qrk;


//! 取得情報の表示
void printRawRecvData(ScipHandler::RawRecvData& raw_data) {

  printf("error_code: %x\n", raw_data.error_code);
  printf("capture_first: %d\n", raw_data.capture_first);
  printf("capture_last: %d\n", raw_data.capture_last);
  printf("skip_lines: %d\n", raw_data.skip_lines);
  printf("skip_frames: %d\n", raw_data.skip_frames);
  printf("left_times: %d\n", raw_data.left_times);
  printf("timestamp: %ld\n", raw_data.timestamp);
  printf("\n");
}


//! main
int main(int argc, char *argv[]) {

  SerialCtrl con;
  const char* error_message = connectWithScip(con);
  if (error_message) {
    printf("%s\n", error_message);
    exit(1);
  }

  ScipHandler scip;
  scip.setConnection(&con);

  char message[] = "MD0000000201001\r";
  con.send(message, 16);

  // MD 応答の取得
  ScipHandler::RawRecvData raw_data;
  scip.recvCaptureData(raw_data);
  printRawRecvData(raw_data);

  if (raw_data.error_code != 0) {
    printf("ScipHandler::recvCaptureData: %d\n", raw_data.error_code);
    exit(1);
  }

  // MD データの取得
  size_t n = raw_data.left_times;
  for (size_t i = 0; i < n; ++i) {
    scip.recvCaptureData(raw_data);
    printRawRecvData(raw_data);
  }

  return 0;
}
