/*!
  \file
  \brief ME データの取得サンプル

  \author Satofumi KAMIMURA

  $Id: meScanSample.cpp 187 2008-08-30 10:26:11Z satofumi $
*/

#include <SDL.h>
#include "UrgCtrl.h"
#include "delay.h"

using namespace qrk;


//! main
int main(int argc, char *argv[]) {

  // const char device[] = "COM3";
  const char device[] = "/dev/ttyACM0";

  UrgCtrl urg;
  if (! urg.connect(device)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }
  urg.setCaptureMode(IntensityCapture);

  // データ用のバッファ取得
  size_t data_max = urg.maxBufferSize();
  long* length_data = new long [data_max];
  long* intensity_data = new long [data_max];
  size_t scan_msec = urg.scanMsec();

  fprintf(stderr, "scan_msec: %d\n", scan_msec);

  // データ取得
  enum { CaptureTimes = 10 };
  size_t captures = 0;
  while (captures < CaptureTimes) {
    int n = urg.capture(length_data, data_max);

    if (n == 0) {
      // データ未到着の場合の待機処理
      // 距離データと強度データが返されるため、待機時間は通常の２倍になる
      delay(scan_msec * 2);
      continue;
    }

    if (n < 0) {
      printf("UrgCtrl::capture: %s\n", urg.what());
      exit(1);
    }

    ++captures;
    printf("timestamp: %d\n", urg.timestamp());

    // 強度データの取得
    int intensity_n = urg.intensity(intensity_data, data_max);
    printf("intensity: %d\n", intensity_n);

    // 全ての強度データを表示
    for (int i = 0; i < intensity_n; ++i) {
      printf("%ld, ", intensity_data[i]);
    }
    printf("\n");
  }

  printf("%d / %d\n", captures, CaptureTimes);

  // ME 回以上のデータ取得の場合、明示的に QT を送信をしてデータ取得を中止する
  urg.stopCapture();

  delete [] length_data;
  delete [] intensity_data;

  return 0;
}
