/*!
  \file
  \brief MD によるデータ取得サンプル

  \author Satofumi KAMIMURA

  $Id: mdScanSample.cpp 195 2008-09-01 22:30:06Z satofumi $
*/

#include <SDL.h>
#include "UrgCtrl.h"
#include "delay.h"

using namespace qrk;


//! main
int main(int argc, char *argv[]) {

  // const char device[] = "COM3";
  const char device[] = "/dev/ttyACM0";

  UrgCtrl urg;
  if (! urg.connect(device)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }
  urg.setCaptureMode(AutoCapture);

  // データ用のバッファ取得
  size_t data_max = urg.maxBufferSize();
  long* data = new long [data_max];
  size_t scan_msec = urg.scanMsec();

  fprintf(stderr, "scan_msec: %d\n", scan_msec);

  // データ取得
  enum { CaptureTimes = 10 };
  urg.startCapture(CaptureTimes);

  size_t captures = 0;
  while (captures < CaptureTimes) {
    int n = urg.capture(data, data_max);
    printf("n = %d\n", n);

    if (n == 0) {
      // データ未到着の場合の待機処理
      printf(".\n");
      qrk::delay(scan_msec);
      continue;
    }

    if (n < 0) {
      printf("UrgCtrl::capture: %s\n", urg.what());
      exit(1);
    }

    ++captures;
    printf("timestamp: %d\n", urg.timestamp());

    // 全てのデータを表示
    for (int i = 0; i < n; ++i) {
      printf("%ld, ", data[i]);
    }
    printf("\n");
  }

  printf("%d / %d\n", captures, CaptureTimes);

  // MD データ取得の場合、明示的に QT を送信をしてデータ取得を中止する
  urg.stopCapture();

  delete [] data;

  return 0;
}
