/*!
  \file
  \brief MD 送受信中に切断できるかのサンプル

  \author Satofumi KAMIMURA

  $Id: mdDisconnectSample.cpp 136 2008-07-29 10:27:20Z satofumi $
*/

#include "UrgCtrl.h"

using namespace qrk;


//! main
int main(int argc, char *argv[]) {

  // 接続し、MD でデータを取得中に切断し、再度接続する
  UrgCtrl urg;

  printf("first connect ... ");
  if (! urg.connect("/dev/ttyACM0")) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }
  printf("O.K.\n");

  urg.setCaptureMode(AutoCapture);

  enum {
    CaptureTimesMax = 1,
    //CaptureTimesMax = 10,
  };
  for (size_t i = 0; i < CaptureTimesMax; ++i) {
    long buffer[1];
    printf("capture: ");
    int n = urg.capture(buffer, 1);
    printf("%d\n", n);
    if (n > 0) {
      break;
    }
  }
  urg.disconnect();

  // 再度接続
  bool ret = urg.connect("/dev/ttyACM0");
  printf("reconnect: %s\n", (ret) ? "O.K." : "fail !!!");

  return 0;
}
