/*!
  \file
  \brief ログデータの前方測定距離を出力する

  \author Satofumi KAMIMURA

  $Id: logFrontOutput.cpp 195 2008-09-01 22:30:06Z satofumi $
*/

#include "ScipHandler.h"
#include "SensorParameter.h"
#include "UrgCtrl.h"
#include <cmath>
#include <fstream>

using namespace qrk;


static bool readGdLines(std::ifstream& fin,
                        std::vector<std::string>& lines) {

  std::string line;

  // GD が現れるまで、読みとばす
  while ((line.size() < 2) || line.compare(0, 5, "GD000")) {
    if (! getline(fin, line)) {
      return false;
    }
  }
  lines.push_back(line);

  // GD 後の改行までを読み出したら、戻す
  while (getline(fin, line)) {
    if (line.size() <= 1) {
      break;
    }
    lines.push_back(line);
  }

  return true;
}


//! main
int main(int argc, char *argv[]) {

  std::ifstream fin("raw_output.txt");
  if (! fin.is_open()) {
    printf("raw_output.txt is not found.\n");
    exit(1);
  }

  // GD 情報を登録
  ScipHandler::RawRecvData raw_data;
  raw_data.type = ScipHandler::GD;

  ScipHandler scip;

  // PP 情報を登録
  SensorParameter parameter;
#if 0
  // Hi-URG
  parameter.area_total = 1024;
  parameter.area_front = 384;
  parameter.area_min = 30;
#else
  // Top-URG
  parameter.area_total = 1440;
  parameter.area_front = 540;
  parameter.area_min = 23;
#endif

  UrgCtrl urg;
  urg.setSensorParameter(&parameter);

  size_t index = 0;
  while (readGdLines(fin, raw_data.lines)) {
    if (raw_data.lines.size() <= 4) {
      continue;
    }

    std::vector<long> points_length;
    scip.convertToLength(points_length, raw_data);

    size_t front_length = points_length[parameter.area_front];
    size_t timestamp = ScipHandler::encode(raw_data.lines[2].c_str(), 4);
    printf("%03d, front: %d, timestamp: %d\n", index, front_length, timestamp);

    raw_data.lines.clear();
    ++index;
  }

  return 0;
}
