/*!
  \file
  \brief getVersionLines の動作サンプル

  \author Satofumi KAMIMURA

  $Id: getVersionLinesSample.cpp 136 2008-07-29 10:27:20Z satofumi $
*/

#include <SDL.h>
#include "ScipHandler.h"
#include "SerialCtrl.h"
#include "ConnectWithScip.h"

using namespace qrk;


//! main
int main(int argc, char *argv[]) {

  SerialCtrl con;
  const char* error_message = connectWithScip(con);
  if (error_message) {
    printf("%s\n", error_message);
    exit(1);
  }

  ScipHandler scip;
  scip.setConnection(&con);

  // バージョン情報の取得
  std::vector<std::string> lines;
  if (! scip.versionLines(lines)) {
    printf("ScipHandler::getVersionLines: %s\n", scip.what());
    exit(1);
  }

  // バージョン情報の出力
  for (std::vector<std::string>::iterator it = lines.begin();
       it != lines.end(); ++it) {
    printf("%s\n", it->c_str());
  }
  return 0;
}
