/*!
  \file
  \brief PP コマンド情報の取得サンプル

  \author Satofumi KAMIMURA

  $Id: getParametersSample.cpp 136 2008-07-29 10:27:20Z satofumi $
*/

#include <SDL.h>
#include "SerialCtrl.h"
#include "ConnectWithScip.h"
#include "ScipHandler.h"
#include "SensorParameter.h"

using namespace qrk;


//! main
int main(int argc, char *argv[]) {

  SerialCtrl con;
  const char* error_message = connectWithScip(con);
  if (error_message) {
    printf("%s\n", error_message);
    exit(1);
  }

  ScipHandler scip;
  scip.setConnection(&con);

  // パラメータ情報の取得
  SensorParameter parameter;
  if (! scip.parameters(&parameter)) {
    printf("ScipHandler::getParameters: %s\n", scip.what());
    exit(1);
  }

  // パラメータ情報の出力
  printf("model: %s\n", parameter.model.c_str());
  printf("distance_min: %ld\n", parameter.distance_min);
  printf("distance_max: %ld\n", parameter.distance_max);
  printf("area_total: %d\n", parameter.area_total);
  printf("area_min: %d\n", parameter.area_min);
  printf("area_max: %d\n", parameter.area_max);
  printf("area_front: %d\n", parameter.area_front);
  printf("scan_rpm: %d\n", parameter.scan_rpm);

  return 0;
}
