/*!
  \file
  \brief データ取得サンプル

  \author Satofumi KAMIMURA

  $Id: gdScanSample.cpp 136 2008-07-29 10:27:20Z satofumi $
*/

#include <SDL.h>
#include "UrgCtrl.h"

using namespace qrk;


//! main
int main(int argc, char *argv[]) {

  //const char device[] = "COM3";
  const char device[] = "/dev/ttyACM0";

  UrgCtrl urg;
  if (! urg.connect(device)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  // データ用のバッファ取得
  size_t data_max = urg.maxBufferSize();
  long* data = new long [data_max];

  // データ取得
  int n = urg.capture(data, data_max);
  printf("n = %d\n", n);
  if (n < 0) {
    printf("UrgCtrl::capture: %s\n", urg.what());
    exit(1);
  }

  printf("timestamp: %d\n", urg.timestamp());
  for (int i = 0; i < n; ++i) {
    printf("%ld, ", data[i]);
  }
  printf("\n");

  delete [] data;
  return 0;
}
