/*!
  \file
  \brief FindUrgPorts の動作サンプル

  \author Satofumi KAMIMURA

  $Id: findUrgPortsSample.cpp 179 2008-08-28 00:10:05Z satofumi $
*/

#include <SDL.h>
#include "UrgUsbCom.h"
#include "FindComPorts.h"

using namespace qrk;


//! main
int main(int argc, char *argv[]) {

  UrgUsbCom urg_usb;
  FindComPorts urg_finder(&urg_usb);
  std::vector<std::string> ports = urg_finder.find();

  // 見付かったポートを全て出力する
  printf("ports: %d\n", ports.size());
  for (std::vector<std::string>::iterator it = ports.begin();
       it != ports.end(); ++it) {
    printf("%s\n", it->c_str());
  }

  return 0;
}
