/*!
  \file
  \brief UrgCtrl の接続サンプル

  \author Satofumi KAMIMURA

  $Id: connectSample.cpp 187 2008-08-30 10:26:11Z satofumi $
*/

#include <SDL.h>
#include "UrgCtrl.h"
#include "getTicks.h"

using namespace qrk;


//! 接続にかかった時間を出力して終了する
int main(int argc, char *argv[]) {

  UrgCtrl urg;

  for (size_t i = 0; i < 3; ++i) {
    int first_ticks = getTicks();
    bool ret = urg.connect("/dev/ttyACM0");
    int spent_msec = getTicks() - first_ticks;

    printf("%d [msec], return: %s, %s\n",
           spent_msec, (ret ? "true" : "false"), urg.what());
  }

  return 0;
}
