#ifndef CONNECT_WITH_SCIP_H
#define CONNECT_WITH_SCIP_H

/*!
  \file
  \brief URG への接続

  \author Satofumi KAMIMURA

  $Id: ConnectWithScip.h 173 2008-08-25 13:47:25Z satofumi $
*/

namespace qrk {
  class Connection;

  /*!
    \brief SCIP のプロトコルタイプ
  */
  typedef enum {
    SCIP_20,
    SCIP_11,
  } ScipType;

  /*!
    \brief 接続して "SCIP2.0" コマンドを送信する
  */
  const char* connectWithScip(qrk::Connection& con,
                              ScipType protocol = SCIP_20);
};

#endif /* !CONNECT_WITH_SCIP_H */
