/*!
  \file
  \brief URG への接続

  \author Satofumi KAMIMURA

  $Id: ConnectWithScip.cpp 179 2008-08-28 00:10:05Z satofumi $
*/

#include "UrgUsbCom.h"
#include "ConnectWithScip.h"
#include "FindComPorts.h"
#include "Connection.h"
#include "ScipHandler.h"

using namespace qrk;


const char* qrk::connectWithScip(qrk::Connection& con, ScipType type) {

  // URG ポートへの接続
  UrgUsbCom urg_usb;
  FindComPorts port_finder(&urg_usb);
  std::vector<std::string> ports = port_finder.find();

  if (ports.empty()) {
    return "Not found urg port.";
  }
  const char* urg_port = ports[0].c_str();

  if (! con.connect(urg_port, 19200)) {
    return (std::string("SerialCtrl::connect: ") + con.what()).c_str();
  }

  if (type == SCIP_20) {
    // SCIP2.0 への切り替え
    ScipHandler scip;
    scip.setConnection(&con);
    scip.sendScip20();
  }

  return NULL;
}
