#ifndef REMOVE_SHARP_ANGLE_POINTS_H
#define REMOVE_SHARP_ANGLE_POINTS_H

/*!
  \file
  \brief センサ中心と鋭角をなすデータの除去

  URG センサにおいて、隣り合う距離データとのなす角がセンサ中心からの角度に近い場合、そのデータは有効でないデータの可能性が高い。本関数では、そのようなデータ点野除去を行う。

  \todo 図示する

  \author Satofumi KAMIMURA

  $Id: removeSharpAnglePoints.h 210 2008-09-03 12:48:02Z satofumi $
*/

namespace qrk
{
  class RangeSensor;
  class Angle;

  /*!
    \brief センサ中心と鋭角をなすデータの除去

    \param[i] data 距離データ配列
    \param[i] size データ点数
  */
  void removeSharpAnglePoints(const RangeSensor* sensor,
                              long data[], int size, const Angle& angle);


  /*!
    \overload
  */
  void removeSharpAnglePoints(const RangeSensor* sensor,
                              long data[], int size);
};

#endif /* !REMOVE_SHARP_ANGLE_POINTS_H */

