/*!
  \file
  \brief センサ中心と鋭角をなすデータの除去

  \author Satofumi KAMIMURA

  $Id: removeSharpAnglePoints.cpp 210 2008-09-03 12:48:02Z satofumi $

  \todo 高速化する
*/

#include "removeSharpAnglePoints.h"
#include "RangeSensor.h"
#include "AngleTypes.h"
#include "GridTypes.h"
#include "MathUtils.h"

using namespace qrk;


namespace
{
  Grid<double> point(const RangeSensor* sensor, long length, int index)
  {
    double radian = sensor->index2rad(index);
    double x = length * cos(radian);
    double y = length * sin(radian);

    return Grid<double>(x, y);
  }
};


void qrk::removeSharpAnglePoints(const RangeSensor* sensor,
                                 long data[], int size, const Angle& angle)
{
  if (size <= 0) {
    return;
  }

  const double compare_radian = angle.to_rad();

  enum {
    InvalidData = 0,
  };
  //bool valid = true;
  Grid<double> p0 = point(sensor, data[0], 0);

  for (int i = 1; i < size; ++i) {

    // data[i - 1] と data[i] と角度と、
    // (0, 0) と data[i] との角度の差が指定範囲内かどうか、で判定する
    Grid<double> p1 = point(sensor, data[i], i);
    double angle_radian =
      fabsl(atan2(p1.y - p0.y, p1.x - p0.x) - atan2(p1.y, p1.x));
    angle_radian -= (angle_radian > (M_PI / 2.0)) ? (M_PI / 2.0) : 0.0;
#if 1
    double a = fabsl(atan2(p1.y - p0.y, p1.x - p0.x));
    double b = fabsl(atan2(p1.y, p1.x));

    double c = fabsl(a - b);
    if (c > (M_PI / 2.0)) {
      c -= c - (M_PI / 2.0);
    }

    fprintf(stderr, "% 3d: %d, %d, %d, %d\n", i,
            static_cast<int>(a * 180.0 / M_PI),
            static_cast<int>(b * 180.0 / M_PI),
            static_cast<int>(c * 180.0 / M_PI), data[i]);

#endif
    if (c <= compare_radian) {
      data[i] = InvalidData;
      //valid = true;
    }
    p0 = p1;
  }

  // 最後の点が無効になったら、data[size - 1] も無効にする
  // !!!
#if 0
  if (! valid) {
    data[size - 1] = InvalidData;
  }
#endif
}


//! \todo 初期角度を適切になるようにチューニングする
void qrk::removeSharpAnglePoints(const RangeSensor* sensor,
                                 long data[], int size)
{
  removeSharpAnglePoints(sensor, data, size, deg(5));
}

