/*!
  \file
  \brief 距離データの 2D 変換

  \author Satofumi KAMIMURA

  $Id: convert2D.cpp 228 2008-09-21 11:05:40Z satofumi $
*/

#include "convert2D.h"
#include "RangeSensor.h"
#include "MathUtils.h"


void qrk::convert2D(std::vector<qrk::Grid<int> >& points,
                    const RangeSensor* sensor,
                    const long* data, size_t size, const Position<int>* offset)
{
  int min_distance = sensor->minDistance();
  int max_distance = sensor->maxDistance();

  Position<int> additional_offset =
    (offset) ? *offset : Position<int>(0, 0, deg(0));
  double additional_radian = -additional_offset.to_rad();

  for (size_t i = 0; i < size; ++i) {
    long distance = data[i];
    if ((distance <= min_distance) || (distance >= max_distance)) {
      continue;
    }

    double radian = sensor->index2rad(i) + additional_radian;
    int x = static_cast<int>(distance * cos(radian)) + additional_offset.x;
    int y = static_cast<int>(distance * sin(radian)) + additional_offset.y;

    Grid<int> point(x, y);
    points.push_back(point);
  }
}
