#ifndef C_URG_ERRNO_H
#define C_URG_ERRNO_H

/*!
  \file
  \brief URG のエラーコード

  \author Satofumi KAMIMURA

  $Id: urg_errno.h 143 2008-08-05 18:39:57Z satofumi $
*/

enum {
  UrgNoError = 0,               /*!< 正常 */
  UrgNotImplemented = -1,       /*!< 未実装 */
  UrgSendFail = -2,
  UrgRecvFail = -3,
  UrgScip10 = -4,               /*!< SCIP1.0 応答 */
  UrgSsFail = -5,               /*!< SS コマンド応答に失敗 */
  UrgAdjustBaudrateFail = -7,   /*!< ボーレート合わせに失敗 */
  UrgInvalidArgs = -8,          /*!< 不正な引数指定 */

  // !!!

};


/*!
  \brief エラーを示す文字列を返す

  \param[in] urg_errno URG のエラー戻り値

  \return エラーを示す文字列
*/
extern const char* urg_strerror(int urg_errno);

#endif /* !C_URG_ERRNO_H */
