/*!
  \file
  \brief バージョン情報の取得

  URG のバージョン文字列を取得する

  \author Satofumi KAMIMURA

  $Id: get_version_lines.c 136 2008-07-29 10:27:20Z satofumi $
*/

#include <stdio.h>
#include <stdlib.h>
#include "urg_ctrl.h"


//! main
int main(int argc, char *argv[]) {

  enum {
    LinesMax = 5,
  };

  //const char device[] = "COM3"; /* Windows での例 */
  const char device[] = "/dev/ttyACM0"; /* Linux での例 */

  char buffer[LinesMax][UrgLineWidth];
  char *lines[LinesMax];
  int ret;
  int i;

  /* 接続 */
  urg_t urg;
  ret = urg_connect(&urg, device, 115200);
  if (ret < 0) {
    printf("urg_connect: %s\n", urg_error(&urg));
    exit(1);
  }

  /* バージョン情報の取得 */
  for (i = 0; i < LinesMax; ++i) {
    lines[i] = buffer[i];
  }
  ret = urg_versionLines(&urg, lines, LinesMax);
  printf("urg_getVersion: %s\n", urg_error(&urg));
  if (ret < 0) {
    urg_disconnect(&urg);
    exit(1);
  }

  /* 表示 */
  for (i = 0; i < LinesMax; ++i) {
    printf("%s\n", lines[i]);
  }

  /* 切断 */
  urg_disconnect(&urg);

  return 0;
}
