/*!
  \file
  \brief パラメータ取得サンプル

  URG パラメータの取得を行う

  \author Satofumi KAMIMURA

  $Id: get_parameters.c 136 2008-07-29 10:27:20Z satofumi $
*/

#include <stdio.h>
#include <stdlib.h>
#include "urg_ctrl.h"


//! main
int main(int argc, char *argv[]) {

  //const char device[] = "COM3"; /* Windows での例 */
  const char device[] = "/dev/ttyACM0"; /* Linux での例 */

  urg_t urg;
  urg_parameter_t parameters;
  int ret;

  /* 接続 */
  ret = urg_connect(&urg, device, 115200);
  if (ret < 0) {
    printf("urg_connect: %s\n", urg_error(&urg));
    exit(1);
  }

  /* センサパラメータの取得 */
  ret = urg_parameters(&urg, &parameters);
  printf("urg_getParameters: %s\n", urg_error(&urg));
  if (ret < 0) {
    urg_disconnect(&urg);
    exit(1);
  }

  /* 表示 */
  printf("distance_min: %ld\n", parameters.distance_min_);
  printf("distance_max: %ld\n", parameters.distance_max_);
  printf("area_total: %d\n", parameters.area_total_);
  printf("area_min: %d\n", parameters.area_min_);
  printf("area_max: %d\n", parameters.area_max_);
  printf("area_front: %d\n", parameters.area_front_);
  printf("scan_rpm: %d\n", parameters.scan_rpm_);
  printf("\n");

  /* urg 構造体からの情報を表示 (上と同じリソースより) */
  printf("urg_getDistanceMax(): %ld\n", urg_maxDistance(&urg));
  printf("urg_getDistanceMin(): %ld\n", urg_minDistance(&urg));
  printf("urg_getScanMsec(): %d\n", urg_scanMsec(&urg));
  printf("urg_getDataMax(): %d\n", urg_dataMax(&urg));

  return 0;
}
