/*!
  \file
  \brief タイムスタンプの評価サンプル

  \author Satofumi KAMIMURA

  $Id: evaluate_timestamp.c 136 2008-07-29 10:27:20Z satofumi $
*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "urg_ctrl.h"
#include "delay.h"


static void urg_exit(urg_t *urg, const char *message) {

  printf("%s: %s\n", message, urg_error(urg));
  urg_disconnect(urg);

  exit(1);
}


//! main
int main(int argc, char *argv[]) {

  enum {
    CaptureTimes = 20,          /* データ取得回数 */
  };

  //const char device[] = "COM3"; /* Windows での例 */
  const char device[] = "/dev/ttyACM0"; /* Linux での例 */

  int data_max;
  long* data;
  int timestamp;
  int pre_timestamp;
  int scan_msec;
  urg_parameter_t parameter;
  int ret;
  int n;
  int i;

  /* 接続 */
  urg_t urg;
  ret = urg_connect(&urg, device, 115200);
  if (ret < 0) {
    printf("urg_connect: %s\n", urg_error(&urg));
    exit(1);
  }

  /* 受信バッファの確保 */
  data_max = urg_dataMax(&urg);
  data = (long*)malloc(sizeof(long) * data_max);
  if (data == NULL) {
    perror("data buffer");
    exit(1);
  }
  urg_parameters(&urg, &parameter);
  scan_msec = urg_scanMsec(&urg);

  /* MD でのデータ要求。取得回数は CaptureTimes 回 */
  /* 100 回以上の連続データを取得するには、取得回数を無限回に設定すること */
  /* urg_setCaptureTimes(&urg, UrgInfinityTimes); */
  assert(CaptureTimes < 100);
  urg_setCaptureTimes(&urg, CaptureTimes);
  ret = urg_requestData(&urg, URG_MD, URG_FIRST, URG_LAST);
  if (ret < 0) {
    urg_exit(&urg, "urg_requestData()");
  }

  /* データ取得 */
  pre_timestamp = 0;
  for (i = 0; i < CaptureTimes; ++i) {
    delay(scan_msec);

    n = urg_receiveData(&urg, data, data_max);
    if (n < 0) {
      urg_exit(&urg, "urg_receiveData()");
    }

    /* 前方の距離データを、タイムスタンプ付きで表示する */
    timestamp = urg_recentTimestamp(&urg);
    printf("%d: %ld [mm], %d [msec], %d\n",
           i, data[parameter.area_front_], timestamp,
           pre_timestamp - timestamp);
    pre_timestamp = timestamp;
  }

  urg_disconnect(&urg);
  free(data);

  return 0;
}
