#ifndef URG_USB_COM_H
#define URG_USB_COM_H

/*!
  \file
  \brief USB 接続されているポートの探索

  \author Satofumi KAMIMURA

  $Id: UrgUsbCom.h 179 2008-08-28 00:10:05Z satofumi $
*/

#include "IsUsbCom.h"


namespace qrk
{
  class UrgUsbCom : public IsUsbCom
  {
    UrgUsbCom(const UrgUsbCom& rhs);
    UrgUsbCom& operator = (const UrgUsbCom& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    UrgUsbCom(void);
    ~UrgUsbCom(void);

    std::vector<std::string> setBaseNames(void);
    bool isUsbCom(const char* com_port);
  };
};

#endif /* !URG_USB_COM_H */
