#ifndef SENSOR_PARAMETER_H
#define SENSOR_PARAMETER_H

/*!
  \file
  \brief センサパラメータ管理

  \author Satofumi KAMIMURA

  $Id: SensorParameter.h 166 2008-08-24 00:37:24Z satofumi $
*/

#include <string>


namespace qrk
{
  /*!
    \brief センサパラメータ管理クラス
  */
  class SensorParameter
  {
  public:
    enum {
      MODL = 0,                 //!< センサ型式情報
      DMIN,                     //!< 最小計測可能距離 [mm]
      DMAX,                     //!< 最大計測可能距離 [mm]
      ARES,                     //!< 角度分解能(360度の分割数)
      AMIN,                     //!< 最小計測可能方向値
      AMAX,                     //!< 最大計測可能方向値
      AFRT,                     //!< 正面方向値
      SCAN,                     //!< 標準操作角速度
    };
    std::string model;          //!< 取得した MODL 情報
    long distance_min;          //!< 取得した DMIN 情報
    long distance_max;          //!< 取得した DMAX 情報
    int area_total;             //!< 取得した ARES 情報
    int area_min;               //!< 取得した AMIN 情報
    int area_max;               //!< 取得した AMAX 情報
    int area_front;             //!< 取得した AFRT 情報
    int scan_rpm;               //!< 取得した SCAN 情報

  SensorParameter(void)
    : model(""), distance_min(0), distance_max(0), area_total(0),
      area_min(0), area_max(0), area_front(0), scan_rpm(600)
    {
    }
  };
};

#endif /* !SENSOR_PARAMETER_H */
