/*!
  \file
  \brief 距離データの平滑化

  \author Satofumi KAMIMURA

  $Id: shmoothRangeLength.cpp 218 2008-09-12 22:24:26Z satofumi $
*/

#include "shmoothRangeLength.h"
#include "RangeSensor.h"
#include "MovingMedian.h"
#include "MovingAverage.h"

using namespace qrk;


void qrk::shmoothRangeLength(std::vector<long>& data, const RangeSensor* sensor)
{
  enum {
    MedianPoints = 5,
    AveragePoints = 3,
  };

  int min_length = sensor->minDistance();
  int max_length = sensor->maxDistance();

  MovingMedian<long> median_filter(MedianPoints);
  MovingAverage<long> moving_average(AveragePoints);

  for (std::vector<long>::iterator it = data.begin(); it != data.end(); ++it) {
    long length = *it;
    if ((length <= min_length) || (length >= max_length)) {
      continue;
    }
    long median = median_filter.push_back(length);
    *it = moving_average.push_back(median);
  }
  rotate(data.begin(), data.begin() + AveragePoints, data.end());
}
