/*!
  \file
  \brief VV データ内容の表示

  \author Satofumi KAMIMURA

  $Id: viewVvSample.cpp 290 2008-10-22 15:35:54Z satofumi $
*/

#include "mUrgCtrl.h"
#include <iostream>

using namespace qrk;


int main(int argc, char *argv[])
{
  mUrgCtrl urg(argc, argv);

  if (! urg.connect("/dev/ttyACM0")) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  // バージョン情報の出力
  std::vector<std::string> lines;
  urg.versionLines(lines);
  if (lines.empty()) {
    std::cerr << "UrgCtrl::versionLines: " << urg.what() << std::endl;
    exit(1);
  }

  for (std::vector<std::string>::iterator it = lines.begin();
       it != lines.end(); ++it) {
    std::cout << *it << std::endl;
  }

  return 0;
}
