/*!
  \file
  \brief タイムスタンプ合わせの動作サンプル

  \author Satofumi KAMIMURA

  $Id: setTimestampSample.cpp 293 2008-10-23 14:33:32Z satofumi $
*/

#include "mUrgCtrl.h"
#include "getTicks.h"


using namespace qrk;

int main(int argc, char *argv[])
{
  mUrgCtrl urg(argc, argv);

  if (! urg.connect("/dev/ttyACM0")) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  int timestamp = -1;
  std::vector<long> data;
  urg.capture(data, &timestamp);
  printf("timestamp: %d\n", timestamp);

  // 現在の PC タイムスタンプと URG のタイムスタンプを同期させる
  urg.setTimestamp(getTicks());

  for (int i = 0; i < 5; ++i) {
    printf("PC : %d\t", getTicks());
    urg.capture(data, &timestamp);
    printf("URG: %d, %d\n", timestamp, getTicks());
  }

  return 0;
}
