/*!
  \file
  \brief 複数 URG を用いてデータ取得を行うサンプル

  ２台の URG を用いて、それぞれの前方データを表示する

  \author Satofumi KAMIMURA

  $Id: multiMdScanSample.cpp 280 2008-10-17 04:43:23Z satofumi $

  \attention 動作しない
*/

#include "UrgCtrl.h"
#include "delay.h"


using namespace qrk;


static void urg_exit(UrgCtrl& urg, const char *message) {

  printf("%s: %s\n", message, urg.what());
  urg.disconnect();

  exit(1);
}


//! main
int main(int argc, char *argv[]) {

  enum { Times = 10 };

  //const char *connect_devices[] = { "COM3", "COM4" };
  const char *connect_devices[] = { "/dev/ttyACM0", "/dev/ttyACM1" };

  // 接続
  UrgCtrl urg[2];
  for (int i = 0; i < 2; ++i) {
    if (! urg[i].connect(connect_devices[i])) {
      urg_exit(urg[i], "UrgCtrl::connect()");
    }

    // データを間引くと、連続転送が容易になる
    // 間引き指定が 2 だと、データ転送量は半分になる
    //urg.setCaptureSkipLines(2);
    urg[i].setCaptureTimes(Times);
    urg[i].setCaptureMode(AutoCapture);
  }

  int remain_times[2] = { -1, -1 };
  while ((remain_times[0] != 0) || (remain_times[1] != 0)) {
    for (int i = 0; i < 2; ++i) {

      /* データ取得 */
      std::vector<long> data;
      int timestamp = 0;
      int n = urg[i].capture(data, &timestamp);
      if (n < 0) {
        urg_exit(urg[i], "UrgCtrl::capture()");
      } else if (n == 0) {
        delay(1);
        continue;
      }

      printf("    %d: ", i);
      /* データ取得が完了していたら、終了 */
      remain_times[i] = urg[i].remainCaptureTimes();
      printf("(%03d/%03d): ", remain_times[i], Times);
      if (remain_times <= 0) {
        continue;
      }

      /* 表示 */
      printf("timestamp: %d, ", timestamp);
      printf("\n");

#if 0
      for (j = 0; j < n; ++j) {
        printf("%d:%ld, ", j, data[i][j]);
      }
      printf("\n\n");
#endif
    }
  }

  return 0;
}
