/*!
  \file
  \brief 距離データのメディアン処理サンプル

  \author Satofumi KAMIMURA

  $Id: medianLengthSample.cpp 218 2008-09-12 22:24:26Z satofumi $

  ./a.out > lines.dat
  gnuplot
  plot 'lines.dat', 'lines.dat' using 1:3, 'lines.dat' using 1:4, 'lines.dat' using 1:5
*/

#include "mUrgCtrl.h"
#include "MovingAverage.h"
#include "MovingMedian.h"
#include "MathUtils.h"

using namespace qrk;


int main(int argc, char *argv[])
{
  mUrgCtrl urg(argc, argv);
  if (! urg.connect("/dev/ttyACM0")) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  int min_length = urg.minDistance();
  int max_length = urg.maxDistance();

  MovingMedian<long> median_filter(5);
  MovingAverage<long> average_filter(5);
  MovingAverage<long> median_average_filter(3);

  std::vector<long> data;
  int n = urg.capture(data);
  for (int i = 0; i < n; ++i) {
    long length = data[i];
    if ((length <= min_length) || (length >= max_length)) {
      continue;
    }

    // 距離データのメディアン処理結果を出力
    double degree = urg.index2rad(i) * 180.0 / M_PI;
    long median = median_filter.push_back(length);
    average_filter.push_back(length);
    median_average_filter.push_back(median);
    printf("%.2f\t%ld\t%ld\t%ld\t%ld\n",
           degree, length,
           average_filter.average(),
           median_filter.median(),
           median_average_filter.average());
  }

  return 0;
}
