/*!
  \file
  \brief MD コマンドによるデータ取得サンプル

  \author Satofumi KAMIMURA

  $Id: mdCaptureSample.cpp 287 2008-10-21 21:32:54Z satofumi $
*/

#include "mUrgCtrl.h"
#include "delay.h"
#include "getTicks.h"

using namespace qrk;


int main(int argc, char *argv[])
{
  //UrgCtrl urg;
  mUrgCtrl urg(argc, argv);

  if (! urg.connect("/dev/ttyACM0")) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  // 取得モードを MD に設定
  urg.setCaptureMode(AutoCapture);
  int scan_msec = urg.scanMsec();

  // MD コマンドで連続データ取得を行い、指定回数だけ出力する
  int pre_timestamp = 0;
  enum { CaptureTimes = 20 };
  getTicks();
  for (int i = 0; i < CaptureTimes;) {
    int timestamp = -1;
    std::vector<long> data;
    int n = urg.capture(data, &timestamp);
    //fprintf(stderr, "n = %d, (%d)\n", n, getTicks());
    if (n <= 0) {
      delay(scan_msec);
      continue;
    }

    printf("timestamp: %d, (%d), %d\n",
           timestamp, getTicks(), timestamp - pre_timestamp);
    pre_timestamp = timestamp;
#if 0
    for (int j = 0; j < n; ++j) {
      printf("%d:%ld, ", j, data[j]);
    }
    printf("\n");
#endif
    ++i;
  }
  return 0;
}
