/*!
  \file
  \brief GD の範囲を変えながら応答を確認する

  \author Satofumi KAMIMURA

  $Id: gdRangeTest.cpp 302 2008-10-26 23:12:43Z satofumi $
*/

#include "mUrgCtrl.h"
#include "UrgUsbCom.h"
#include "FindComPorts.h"
#include <SDL.h>

using namespace qrk;


namespace {
  std::vector<std::string> findUrgPort(void)
  {
    UrgUsbCom urg_usb;
    FindComPorts urg_finder(&urg_usb);
    return urg_finder.find();
  }
};


int main(int argc, char *argv[])
{
  std::vector<std::string> urg_ports = findUrgPort();
  if (urg_ports.empty()) {
    printf("no URG ports.\n");
    exit(1);
  }

  printf("%s\n", urg_ports[0].c_str());
  mUrgCtrl urg(argc, argv);
  if (! urg.connect(urg_ports[0].c_str())) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  std::vector<long> data;
  for (int last = 500; last >= 0; --last) {
    //urg.setCaptureRange(0, last);
    urg.setCaptureRange(0, 301);
    int n = urg.capture(data);

    printf("%3d: n = %d\n", last, n);
  }

  return 0;
}
