/*!
  \file
  \brief GD コマンドによるデータ取得サンプル

  \author Satofumi KAMIMURA

  $Id: gdCaptureSample.cpp 215 2008-09-08 12:44:08Z satofumi $
*/

#include "mUrgCtrl.h"

using namespace qrk;


int main(int argc, char *argv[])
{
  //UrgCtrl urg;
  mUrgCtrl urg(argc, argv);

  if (! urg.connect("/dev/ttyACM0")) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  // GD コマンドで１スキャン分のデータ取得を行い、指定回数だけ出力する
  enum { CaptureTimes = 1 };
  for (int i = 0; i < CaptureTimes; ++i) {
    int timestamp = -1;
    std::vector<long> data;

    int n = urg.capture(data, &timestamp);

    printf("timestamp: %d\n", timestamp);
    for (int j = 0; j < n; ++j) {
      printf("%d:%ld, ", j, data[j]);
    }
    printf("\n");
  }
  return 0;
}
