/*!
  \file
  \brief 直線検出の動作サンプル

  \author Satofumi KAMIMURA

  $Id: detectLineSample.cpp 218 2008-09-12 22:24:26Z satofumi $
*/

#include "mUrgCtrl.h"
#include "shmoothRangeLength.h"
#include "convertRangePoints.h"
#include "normarizePointsInterval.h"

#include "shmoothPoints.h"
#include "convertLineSegment.h"

#include "removeLaserErrorLine.h"

#include "StopWatch.h"


using namespace qrk;


int main(int argc, char *argv[])
{
  mUrgCtrl urg(argc, argv);
  if (! urg.connect("/dev/ttyACM0")) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  std::vector<long> data;
  int n = urg.capture(data);
  if (n <= 0) {
    printf("UrgCtrl::capture: %s\n", urg.what());
    exit(1);
  }

  StopWatch stop_watch;
  stop_watch.start();

  // 距離データを点列に変換
  std::vector<Grid<long> > points;

  // 距離データの平滑化
  shmoothRangeLength(data, &urg);

  // 距離データを点列に変換
  convertRangePoints(points, data, &urg);

  stop_watch.pause();
  // 点データの出力
  FILE* fd = fopen("points.dat", "w");
  if (fd) {
    for (std::vector<Grid<long> >::iterator it = points.begin();
         it != points.end(); ++it) {
      fprintf(fd, "%ld\t%ld\n", it->x, it->y);
    }
    fclose(fd);
  }
  stop_watch.resume();

  // 点列の平滑化
  normarizePointsInterval(points);
  shmoothPoints(points);

  stop_watch.pause();
  // 点データの出力
  fd = fopen("n_points.dat", "w");
  if (fd) {
    for (std::vector<Grid<long> >::iterator it = points.begin();
         it != points.end(); ++it) {
      fprintf(fd, "%ld\t%ld\n", it->x, it->y);
    }
    fclose(fd);
  }
  stop_watch.resume();

  // 線分の検出
  std::vector<Line<long> > lines;
  convertLineSegment(lines, points);
  removeLaserErrorLine(lines);
  stop_watch.pause();

  fprintf(stderr, "%d [msec]\n", stop_watch.getTicks());

  printf("plot 'points.dat' pointsize 0, 'n_points.dat' pointsize 0\n");

  // 線データの出力
  for (std::vector<Line<long> >::iterator it = lines.begin();
       it != lines.end(); ++it) {
    // 表示を見やすくするために、ずらして描画させる
    //int offset = 30;
    int offset = 0;
    printf("set arrow from %ld, %ld to %ld, %ld\t# %.2f\n",
           it->start.x + offset, it->start.y + offset,
           it->end.x + offset, it->end.y + offset,
           it->probability);
  }

  printf("pause -1\n");

  return 0;
}
