/*!
  \file
  \brief X-Y 平面への距離データ変換サンプル

  \author Satofumi KAMIMURA

  $Id: convert2dSample.cpp 218 2008-09-12 22:24:26Z satofumi $
*/

#include "mUrgCtrl.h"
#include "MathUtils.h"

using namespace qrk;


int main(int argc, char *argv[])
{
  mUrgCtrl urg(argc, argv);
  if (! urg.connect("/dev/ttyACM0")) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  int min_length = urg.minDistance();
  int max_length = urg.maxDistance();

  std::vector<long> data;
  int n = urg.capture(data);

  for (int i = 0; i < n; ++i) {
    long length = data[i];
    if ((length <= min_length) || (length >= max_length)) {
      continue;
    }

    double radian = urg.index2rad(i);
    int x = static_cast<int>(length * cos(radian));
    int y = static_cast<int>(length * sin(radian));

    printf("%d\t%d\t#%d\n", x, y, i);
  }

  return 0;
}
