/*!
  \file
  \brief レーザ特性から生じる間違った直線の除去

  \author Satofumi KAMIMURA

  $Id: removeLaserErrorLine.cpp 222 2008-09-17 12:52:15Z satofumi $
*/

#include "removeLaserErrorLine.h"
#include "geometry.h"

using namespace qrk;


void qrk::removeLaserErrorLine(std::vector<Line<long> >& lines)
{
  std::vector<Line<long> > no_error_lines;

  Grid<long> origin(0, 0);
  for (std::vector<Line<long> >::iterator it = lines.begin();
       it != lines.end(); ++it) {

    // 原点と終点、原点と視点とを結ぶ直線のなす角が狭い直線を除去する
    Angle start_angle = lineAngle<long>(origin, it->start);
    Angle end_angle = lineAngle<long>(origin, it->end);

    if (narrowAngle(start_angle, end_angle).to_deg() >= 6) {
      no_error_lines.push_back(*it);
    }
  }
  std::swap(lines, no_error_lines);
}
