/*!
  \file
  \brief 距離データのグリッド変換

  \author Satofumi KAMIMURA

  $Id: convertRangePoints.cpp 218 2008-09-12 22:24:26Z satofumi $
*/

#include "convertRangePoints.h"
#include "RangeSensor.h"
#include "MathUtils.h"

using namespace qrk;


void qrk::convertRangePoints(std::vector<Grid<long> >& points,
                             const std::vector<long>& data,
                             const RangeSensor* sensor)
{
  long min_length = sensor->minDistance();
  long max_length = sensor->maxDistance();

  int n = data.size();
  for (int i = 0; i < n; ++i) {
    long length = data[i];
    if ((length <= min_length) || (length >= max_length)) {
      continue;
    }

    double radian = sensor->index2rad(i);
    long x = static_cast<long>(length * cos(radian));
    long y = static_cast<long>(length * sin(radian));

    points.push_back(Grid<long>(x, y));
  }
}
