#ifndef CONVERT_2D_H
#define CONVERT_2D_H

/*!
  \file
  \brief 距離データの 2D 変換

  \author Satofumi KAMIMURA

  $Id: convert2D.h 247 2008-09-30 22:22:58Z satofumi $
*/

#include "GridTypes.h"
#include "PositionTypes.h"
#include <vector>


namespace qrk
{
  class RangeSensor;

  void convert2D(std::vector<qrk::Grid<long> >& points,
                 const RangeSensor* sensor, const std::vector<long> data,
                 const qrk::Position<long> offset);

  void convert2D(std::vector<qrk::Grid<long> >& points,
                 const RangeSensor* sensor, const std::vector<long> data);
};

#endif /* !CONVERT_2D_H */
