/*!
  \file
  \brief 距離データの 2D 変換

  \author Satofumi KAMIMURA

  $Id: convert2D.cpp 248 2008-10-01 12:12:49Z satofumi $
*/

#include "convert2D.h"
#include "RangeSensor.h"
#include "MathUtils.h"


void qrk::convert2D(std::vector<qrk::Grid<long> >& points,
                    const RangeSensor* sensor, const std::vector<long> data,
                    const Position<long> offset)
{
  int min_distance = sensor->minDistance();
  int max_distance = sensor->maxDistance();

  double offset_radian = offset.to_rad();

  int index = 0;
  for (std::vector<long>::const_iterator it = data.begin();
       it != data.end(); ++it, ++index) {
    long distance = *it;
    if ((distance <= min_distance) || (distance >= max_distance)) {
      continue;
    }

    double radian = sensor->index2rad(index) + offset_radian;
    int x = static_cast<int>(distance * cos(radian)) + offset.x;
    int y = static_cast<int>(distance * sin(radian)) + offset.y;

    points.push_back(Grid<long>(x, y));
  }
}


void qrk::convert2D(std::vector<qrk::Grid<long> >& points,
                    const RangeSensor* sensor, const std::vector<long> data)
{
  convert2D(points, sensor, data, Position<long>(0, 0, deg(0)));
}
